$(function () {
    // form init
    $('#url').val('');
    $('#custom-hash').val('');

    // converted url
    if ($('#converted-url')[0] != null) {
        _copyConvertedUrl();
        $('#converted-url').on('click focus', function() {
            _copyConvertedUrl(this);
        });
    }

    // validation
    let check1 = true;
    let check2 = true;
    $('#url').on('keyup paste cut', function() {
        setTimeout(function(){
            check1 = _isValidUrl($('#url').val());
            _switchButton(check1, check2);
        }, 100);
    });
    $('#custom-hash').on('keyup paste cut', function() {
        setTimeout(function(){
            check2 = _isValidHash($('#custom-hash').val());
            _switchButton(check1, check2);
        }, 100);
    });

    // accordion
    $('.accordion_btn').on('click', function() {
        $('.custom').slideToggle(300);
        $('.triangle').toggleClass('open', 300);
    });
});

function _isValidUrl(string) {
    try {
        new URL(string);
        return true;
    } catch (err) {
        return false;
    }
}

function _isValidHash(string) {
    len = string.length;
    if (len == 0) {
        return true;
    } else if (len >= 5 && len <= 20) {
        // skip
    } else {
        return false;
    }
    if (string.match(/[^0-9a-zA-Z]/)) {
        return false;
    } else {
        return true;
    }
}

function _switchButton(check1, check2) {
    if (check1 && check2) {
        $('.url .right').prop('disabled', false);
    } else {
        $('.url .right').prop('disabled', true);
    }
}

async function _copyConvertedUrl() {
    try {
        await navigator.clipboard.writeText($('#converted-url').text());
        new jBox('Notice', {
            content: '短縮URLをクリップボードにコピーしました。',
            color: 'green',
            showCountdown: true,
        });
    } catch (err) {
        _selectDomElm($('#converted-url')[0]);
    }
}

function _selectDomElm(obj){
    var range = document.createRange();
    range.selectNodeContents(obj);
    var selection = window.getSelection();
    selection.removeAllRanges();
    selection.addRange(range);
}