<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * AuthIp Model
 *
 * @method \App\Model\Entity\AuthIp newEmptyEntity()
 * @method \App\Model\Entity\AuthIp newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\AuthIp[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\AuthIp get($primaryKey, $options = [])
 * @method \App\Model\Entity\AuthIp findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\AuthIp patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\AuthIp[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\AuthIp|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\AuthIp saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\AuthIp[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\AuthIp[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\AuthIp[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\AuthIp[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 */
class AuthIpTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('auth_ip');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->scalar('ip_version')
            ->maxLength('ip_version', 1)
            ->notEmptyString('ip_version');

        $validator
            ->scalar('ip')
            ->maxLength('ip', 100)
            ->requirePresence('ip', 'create')
            ->notEmptyString('ip');

        $validator
            ->notEmptyString('enabled');

        return $validator;
    }
}
