<?php
declare(strict_types=1);

namespace App\Controller;

use Cake\Core\Configure;
use Cake\ORM\Exception\PersistenceFailedException;

/**
 * MakeShortUrl Controller
 */
class MakeShortUrlController extends AppController
{
    protected $defaultTable = 'ShortUrl';
    const HASH_LENGTH = 10; // 自動生成するHash値の長さ
    const MSG = [
        'Duplicate' => '指定の短縮URLは既に使用されています。',
        'Error' => 'エラーが発生しました。',
    ];

    public function index()
    {
        $this->set(['ShortUrlDomain' => Configure::read('ShortUrlDomain').DS]);

        if ($data['url'] = $this->request->getData('url')) {
            $shortUrl = $this->fetchTable();
            $result = false;
            if ($data['hash'] = $this->request->getData('custom_hash')) {
                // Hash値が指定されているケース
                $customHashFlg = true;
                $isDuplicate = $shortUrl->findByHash($data['hash'])->first();
                if ($isDuplicate) return $this->Flash->error(self::MSG['Duplicate']);
            }

            while (true) {
                try {
                    if (! ($customHashFlg ?? false)) $data['hash'] = $this->_makeHash();
                    $entity = $shortUrl->newEntity($data);
                    if ($result = $shortUrl->saveOrFail($entity)) break;
                } catch (PersistenceFailedException $e) {
                    if ($entity->getError('hash')['unique'] ?? false) {
                        if ($customHashFlg ?? false) {
                            // Hash値が指定されている場合はエラー
                            return $this->Flash->error(self::MSG['Duplicate']);
                        }
                        continue; // 自動生成によるHashの重複は再登録
                    } else {
                        // Hash重複以外はエラー
                        $this->log($e->getTraceAsString(), 'error');
                        $this->Flash->error(self::MSG['Error']);
                        break;
                    }
                }
            }
            $this->set(['shortUrl' => $result]);
        }
    }

    /**
     * Hash値生成
     * @param void
     * @return string Hash値
     */
    private function _makeHash()
    {
        $str = array_merge(range('a', 'z'), range('0', '9'), range('A', 'Z'));
        $r_str = null;
        for ($i = 0; $i < self::HASH_LENGTH; $i++) {
            $r_str .= $str[rand(0, count($str) - 1)];
        }
        return $r_str;
    }
}
